function test_suite = test_gma_1
    initTestSuite;
end

function test_parse_1
    import dspace.Expression
    
    f = {'a1*x1^g111 + a2*x2^g122'};
    xd = {'x1';'x2'};
    [K,sigma,x,xk] = dspace.gma.parse(f,xd);
    
    sigma0 = [1,1];
    K0 = Expression(zeros(1,4,2));
    K0(1,:,1) = Expression({'g111',0,1,0});
    K0(1,:,2) = Expression({0,'g122',0,1});
    x0 = {'x1';'x2';'a1';'a2'};
    xk0 = {'g111';'g122'};
    
    assertEqual(sigma,sigma0);
    assertEqual(K,K0);
    assertEqual(x,x0);
    assertEqual(xk,xk0);
end

function test_parse_2
% Test the parsing of a negative term.

    import dspace.Expression
    
    f = {'a1*x1^g111 - a2*x2^g122'};
    xd = {'x1';'x2'};
    [K,sigma,x,xk] = dspace.gma.parse(f,xd);
    
    sigma0 = [1,-1];
    K0 = Expression(zeros(1,4,2));
    K0(1,:,1) = Expression({'g111',0,1,0});
    K0(1,:,2) = Expression({0,'g122',0,1});
    x0 = {'x1';'x2';'a1';'a2'};
    xk0 = {'g111';'g122'};
    
    assertEqual(sigma,sigma0);
    assertEqual(K,K0);
    assertEqual(x,x0);
    assertEqual(xk,xk0);
end

function test_split_1

    import dspace.Expression
    
    f = {'a1*x1^g111 - a2*x2^g122'};
    xd = {'x1';'x2'};
    [K,sigma,x,xk] = dspace.gma.parse(f,xd);
    [G,H,alpha,beta] = dspace.gma.split(K,sigma);
    
    alpha0 = 1;
    beta0 = 1;
    G0 = Expression({'g111',0,1,0});
    H0 = Expression({0,'g122',0,1});
    x0 = {'x1';'x2';'a1';'a2'};
    xk0 = {'g111';'g122'};
    
    assertEqual(alpha,alpha0);
    assertEqual(beta,beta0);
    assertEqual(G,G0);
    assertEqual(H,H0);
    assertEqual(x,x0);
    assertEqual(xk,xk0);
end

function test_split_2
% Test using random double.

    s = [1 1 -1;-1 1 0];
    k = rand(2,6,3);  % 2 functions, 4 independent vars, 3 terms (max)

    [g,h,a,b] = dspace.gma.split(k,s);

    a0 = [1 1; 1 0];
    b0 = [1; 1];
    g0 = zeros(2,6,2);
    g0(1,:,1) = k(1,:,1);
    g0(1,:,2) = k(1,:,2);
    g0(2,:,1) = k(2,:,2);
    h0 = zeros(2,6,1);
    h0(1,:,1) = k(1,:,3);
    h0(2,:,1) = k(2,:,1);

    assertEqual(a,a0);
    assertEqual(b,b0);
    assertEqual(g,g0);
    assertEqual(h,h0);
end

function test_join

    import dspace.Expression

    f = {'a1*x1^g111 - a2*x2^g122'};
    xd = {'x1';'x2'};
    [K,sigma,x,xk] = dspace.gma.parse(f,xd);
    [G,H,alpha,beta] = dspace.gma.split(K,sigma);
    [K,sigma] = dspace.gma.join(G,H,alpha,beta);

    sigma0 = [1,-1];
    K0 = Expression(zeros(1,4,2));
    K0(1,:,1) = Expression({'g111',0,1,0});
    K0(1,:,2) = Expression({0,'g122',0,1});
    x0 = {'x1';'x2';'a1';'a2'};
    xk0 = {'g111';'g122'};
    
    assertEqual(sigma,sigma0);
    assertEqual(K,K0);
    assertEqual(x,x0);
    assertEqual(xk,xk0);
end

function test_reorder

    import dspace.Expression
    
    k = Expression(zeros(1,4,2));
    k(1,:,1) = Expression({'g111',0,1,0});
    k(1,:,2) = Expression({0,'g122',0,1});
    x = {'x1';'x2';'a1';'a2'};
    x0 = {'x1';'a1';'x2';'a2'};
    
    [k,x] = dspace.gma.reorder(k,x,x0);

    k0 = Expression(zeros(1,4,2));
    k0(1,:,1) = Expression({'g111',1,0,0});
    k0(1,:,2) = Expression({0,0,'g122',1});

    assertEqual(k,k0);
    assertEqual(x,x0);
end

function test_unparse

    import dspace.Expression

    sigma = [1,-1];
    k = Expression(zeros(1,4,2));
    k(1,:,1) = Expression({'g111',0,1,0});
    k(1,:,2) = Expression({0,'g122',0,1});
    x = {'x1';'x2';'a1';'a2'};
    
    [f,xd] = dspace.gma.unparse(k,sigma,x);

    assertEqual(f,{'a1*x1^g111 - a2*x2^g122'});
    assertEqual(xd,{'x1'});
end

function test_signature
    sigma = [1,-1,1,-1,1;1,-1,0,0,0];
    sig = dspace.gma.signature(sigma);
    assertEqual(sig,[3;2;1;1]);
end
