function test_suite = test_gma_2
    initTestSuite;
end

function dat = setup
    dat.f = {'    10*x1*x2*x3*x4^-1 + x1*x2 - x1';
             '(1/10)*x1*x2*x3*x4^-1 + x1*x2 - x2'};
    dat.xd = {'x1';'x2'};
    dat.x = {'x1';'x2';'x3';'x4'};
    dat.xk = {};
    dat.sig = [2;1;2;1];
    dat.sigma = [10,1,-1;1/10,1,-1];
    dat.k(:,:,1) = [1,1,1,-1;1,1,1,-1];
    dat.k(:,:,2) = [1,1,0,0;1,1,0,0];
    dat.k(:,:,3) = [1,0,0,0;0,1,0,0];
    dat.alpha = dat.sigma(:,[1,2]);
    dat.beta = -dat.sigma(:,3);
    dat.g = dat.k(:,:,[1,2]);
    dat.h = dat.k(:,:,3);
end

function test_parse(dat)
    [k,sigma,x,xk] = dspace.gma.parse(dat.f,dat.xd);
    assertEqual(sigma,dat.sigma);
    assertEqual(k,dat.k);
    assertEqual(xk,dat.xk);
end

function test_split(dat)
    [g,h,alpha,beta] = dspace.gma.split(dat.k,dat.sigma);
    assertEqual(alpha,dat.alpha);
    assertEqual(beta,dat.beta);
    assertEqual(g,dat.g);
    assertEqual(h,dat.h);    
end

function test_join(dat)
    [k,sigma] = dspace.gma.join(dat.g,dat.h,dat.alpha,dat.beta);
    assertEqual(sigma,dat.sigma);
    assertEqual(k,dat.k);
end

function test_reorder(dat)
    ord = [2;1;4;3];
    xnew = dat.x(ord);
    knew = dspace.gma.reorder(dat.k,dat.x,xnew);
    assertEqual(knew,dat.k(:,ord,:)); 
end

function test_unparse(dat)
    [f,xd] = dspace.gma.unparse(dat.k,dat.sigma,dat.x);
    f = dspace.util.sym2str(sym(f)+0);  % normalize f
    dat.f = dspace.util.sym2str(sym(dat.f)+0);  % normalize dat.f
    assertEqual(f,dat.f);
    assertEqual(xd,dat.xd);
end

function test_signature(dat)
    sig = dspace.gma.signature(dat.sigma);
    assertEqual(sig,dat.sig);
end
