function test_suite = test_linear
    initTestSuite;
end

function test_linprog_feasible_strict_1
    A = [1, 1; 1, 1];
    b = [1; 1];
    f = dspace.linear.linprog_feasible_strict(A,b);
    assertEqual(f,true);
end

function test_linprog_feasible_strict_2
    A = [1, 1; -1, -1];  % opposing constraints (i.e. A*y > b, A*y < b)
    b = [1; -1];
    f = dspace.linear.linprog_feasible_strict(A,b);
    assertEqual(f,false);
end

function test_linprog_feasible_nonstrict_1
    A = [1, 1; 1, 1];
    b = [1; 1];
    f = dspace.linear.linprog_feasible_nonstrict(A,b);
    assertEqual(f,true);
end

function test_linprog_feasible_nonstrict_2
    A = [1, 1; -1, -1];  % opposing constraints (i.e. A*y >= b, A*y <= b)
    b = [1; -1];
    f = dspace.linear.linprog_feasible_nonstrict(A,b);
    assertEqual(f,true);
end

function test_linprog_feasible_nonstrict_3
    A = [1, 1; -1, -1];
    b = [-1; -1];
    f = dspace.linear.linprog_feasible_nonstrict(A,b);
    assertEqual(f,false);
end



