function test_suite = test_sample_2
    initTestSuite;
end

function dat = setup
    f = {'    10*X1*X2*X3^n*X4^m + X1*X2 - X1';
         '(1/10)*X1*X2*X3^n*X4^n + X1*X2 - X2'};
    xd = {'X1';'X2'};
    gma = dspace.parse_gma(f);
    dat.cas = dspace.enumerate_cases(gma);
    dat.bnd = dspace.calculate_boundaries(dat.cas);
    dat.p0 = struct();  % param values
    dat.p0.n = 1;
    dat.p0.m = 1;
    dat.p0.X3 = 10.^[-3,0,3];
    dat.p0.X4 = 10.^[-3,0,3];
    [dat.d,dat.r] = dspace.sample_regions(dat.bnd,dat.p0);
end

function test_sample_steady_state_1(dat)
    f = dspace.ssys.sample_steady_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1');
    f = cellfun(@(x)x{1},f);
    f0 = [1,1,1;1,1,1e-2;1,1e-2,1e-5];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_steady_state_2(dat)
    f = dspace.ssys.sample_steady_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2');
    f = cellfun(@(x)x{1},f);
    f0 = [1,1,1e-1;1,1e-1,1e-4;1e-1,1e-4,1e-7];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_steady_flux_1(dat)
    f = dspace.ssys.sample_steady_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1');
    f = cellfun(@(x)x{1},f);
    f0 = [1,1,1;1,1,1e-2;1,1e-2,1e-5];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_steady_flux_2(dat)
    f = dspace.ssys.sample_steady_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2');
    f = cellfun(@(x)x{1},f);
    f0 = [1,1,1e-1;1,1e-1,1e-4;1e-1,1e-4,1e-7];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_state_1(dat)
    f = dspace.ssys.sample_gain_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','X3');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,0;0,0,-1;0,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_state_2(dat)
    f = dspace.ssys.sample_gain_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','X4');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,0;0,0,-1;0,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_state_3(dat)
    f = dspace.ssys.sample_gain_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','X3');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,-1;0,-1,-1;-1,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_state_4(dat)
    f = dspace.ssys.sample_gain_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','X4');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,-1;0,-1,-1;-1,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_flux_1(dat)
    f = dspace.ssys.sample_gain_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','X3');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,0;0,0,-1;0,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_flux_2(dat)
    f = dspace.ssys.sample_gain_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','X4');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,0;0,0,-1;0,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_flux_3(dat)
    f = dspace.ssys.sample_gain_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','X3');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,-1;0,-1,-1;-1,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_gain_flux_4(dat)
    f = dspace.ssys.sample_gain_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','X4');
    f = cellfun(@(x)x{1},f);
    f0 = [0,0,-1;0,-1,-1;-1,-1,-1];
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_state_1(dat)
    f = dspace.ssys.sample_sensitivity_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','m');
    f = cellfun(@(x)x{1},f);
    f0 = zeros(3,3);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_state_2(dat)
    f = dspace.ssys.sample_sensitivity_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','n');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1;1,1,1e0*1e3;1,1e3*1e0,1e3*1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_state_3(dat)
    f = dspace.ssys.sample_sensitivity_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','m');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1e3;1,1,1e3;1e-3,1,1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_state_4(dat)
    f = dspace.ssys.sample_sensitivity_state(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','n');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1e-3;1,1e0,1e0;1e3,1e3,1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_flux_1(dat)
    f = dspace.ssys.sample_sensitivity_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','m');
    f = cellfun(@(x)x{1},f);
    f0 = zeros(3,3);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_flux_2(dat)
    f = dspace.ssys.sample_sensitivity_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X1','n');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1;1,1,1e0*1e3;1,1e3*1e0,1e3*1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_flux_3(dat)
    f = dspace.ssys.sample_sensitivity_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','m');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1e3;1,1,1e3;1e-3,1,1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_sensitivity_flux_4(dat)
    f = dspace.ssys.sample_sensitivity_flux(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas,'X2','n');
    f = cellfun(@(x)x{1},f);
    f0 = -log([1,1,1e-3;1,1e0,1e0;1e3,1e3,1e3]);
    assertElementsAlmostEqual(f,f0);
end

function test_sample_local_stability(dat)
    f = dspace.ssys.sample_local_stability(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas);
    f = cellfun(@(x)x{1},f);
    f0 = false(3,3);
    assertEqual(f,f0);
end

function test_sample_dominant_eigenvalue(dat)
    f = dspace.ssys.sample_dominant_eigenvalue(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas);
    f = cellfun(@(x)x{1},f);
    f0 = ones(3,3);
    assertElementsAlmostEqual(f,f0);
end
