function test_suite = test_sample_3
    initTestSuite;
end

function dat = setup
    f = {'X9*X3^n - X1';
         'X1 - X2';
         'X6 + X2 - X3 - X3*X1^m';
         };

    dat.gma = dspace.parse_gma(f);
    dat.cas = dspace.enumerate_cases(dat.gma);
    dat.bnd = dspace.calculate_boundaries(dat.cas);
    
    dat.p0 = struct();  % param values
    dat.p0.n = -10;
    dat.p0.m = -0.1;
    dat.p0.X6 = 10.^[-2,2];
    dat.p0.X9 = 10.^[-2,2];
    
    [dat.d,dat.r] = dspace.sample_regions(dat.bnd,dat.p0);
end

function test_sample_local_stability(dat)
    f = dspace.ssys.sample_local_stability(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas);
    f = cellfun(@(x)x{1},f);
    f0 = [true,false;true,true];
    assertEqual(f,f0);
end

function test_sample_dominant_eigenvalue(dat)
    f = dspace.ssys.sample_dominant_eigenvalue(...
        dat.bnd,dat.p0,dat.d,dat.r,dat.cas);
    f = cellfun(@(x)x{1},f);
    f0 = [-0.001639226895308,0.077217345015942;-1,-1];
    assertElementsAlmostEqual(f,f0);
end
