function test_suite = test_system_1
    initTestSuite;
end

function dat = setup
    dat.f = {'    10*x1*x2*x3*x4 + x1*x2 - x1';
             '(1/10)*x1*x2*x3*x4 + x1*x2 - x2'};
    dat.xd = {'x1';'x2'};
    
    dat.gma.x = {'x1';'x2';'x3';'x4'};
    dat.gma.xk = {};
    dat.gma.sig = [2;1;2;1];
    dat.gma.alpha = [10,1;1/10,1];
    dat.gma.beta = [1;1];
    dat.gma.G(:,:,1) = [1,1,1,1;1,1,1,1];
    dat.gma.G(:,:,2) = [1,1,0,0;1,1,0,0];
    dat.gma.H(:,:,1) = [1,0,0,0;0,1,0,0];
    
    dat.cas.x = dat.gma.x;
    dat.cas.xk = dat.gma.xk;
    dat.cas.sig = dat.gma.sig;
    
    dat.cas.alpha(:,:,1) = [10;1/10];  % Case 1) 1111
    dat.cas.alpha(:,:,2) = [10;1];     % Case 2) 1121
    dat.cas.alpha(:,:,3) = [1;1/10];   % Case 3) 2111
    dat.cas.alpha(:,:,4) = [1;1];      % Case 4) 2121
    
    dat.cas.beta(:,:,1) = [1;1];
    dat.cas.beta(:,:,2) = [1;1];
    dat.cas.beta(:,:,3) = [1;1];
    dat.cas.beta(:,:,4) = [1;1];
    
    dat.cas.G(:,:,1) = [1,1,1,1;1,1,1,1];
    dat.cas.G(:,:,2) = [1,1,1,1;1,1,0,0];
    dat.cas.G(:,:,3) = [1,1,0,0;1,1,1,1];
    dat.cas.G(:,:,4) = [1,1,0,0;1,1,0,0];
    
    dat.cas.H(:,:,1) = [1,0,0,0;0,1,0,0];
    dat.cas.H(:,:,2) = [1,0,0,0;0,1,0,0];
    dat.cas.H(:,:,3) = [1,0,0,0;0,1,0,0];
    dat.cas.H(:,:,4) = [1,0,0,0;0,1,0,0];
    
    dat.cas.C(:,:,1) = [0,0,1,1;0,0,1,1];
    dat.cas.C(:,:,2) = [0,0,1,1;0,0,-1,-1];
    dat.cas.C(:,:,3) = [0,0,-1,-1;0,0,1,1];
    dat.cas.C(:,:,4) = [0,0,-1,-1;0,0,-1,-1];

    dat.cas.delta(:,:,1) = [10;1/10];
    dat.cas.delta(:,:,2) = [10;10];
    dat.cas.delta(:,:,3) = [1/10;1/10];
    dat.cas.delta(:,:,4) = [1/10;10];
    
    dat.bnd.sig = dat.cas.sig;
    dat.bnd.xk = dat.cas.xk;
    dat.bnd.xi = {'x3';'x4'};
    dat.bnd.U = dat.cas.C(:,3:4,:);
    dat.bnd.W = zeros(2,2,4);
    dat.bnd.zeta = dat.cas.alpha./dat.cas.beta;
    dat.bnd.delta = dat.cas.delta;
end

function test_parse_gma(dat)
    gma = dspace.parse_gma(dat.f,dat.xd);
    assertEqual(gma,dat.gma);
end

function test_enumerate_cases(dat)
    cas = dspace.enumerate_cases(dat.gma);
    assertEqual(cas,dat.cas);
end

function test_calculate_boundaries(dat)
    bnd = dspace.calculate_boundaries(dat.cas);
    assertEqual(bnd,dat.bnd);
end

function test_is_valid(dat)
    v = dspace.is_valid(dat.bnd);
    assertEqual(v,[true;true;false;true]);  % Case 3 (2111) is invalid)
end

function test_sample_regions(dat)
    p0.x3 = [1/100,1,100];  % log10(x3) = [-2,0,2]
    p0.x4 = [1/100,1,100];  % log10(x4) = [-2,0,2]
    [d,r] = dspace.sample_regions(dat.bnd,p0);
    cas = arrayfun(@(x)find(r(x,:)),d);  % convert to case numbers
    cas0 = [4,4,2;4,2,1;2,1,1];  % x3 in dim 1, x4 in dim 2
    assertEqual(cas,cas0); 
end

function test_measure_tolerance(dat)
    pr = struct();  % no added restrictions on params
    p0.x3 = 5;  % operating point
    p0.x4 = 1;
    [tol,kasenums] = dspace.measure_tolerance(dat.bnd,p0);
    assertEqual(kasenums,2);
    assertElementsAlmostEqual(tol.x3(1),50);  % fold change down: 5 / 50 = 1/10
    assertElementsAlmostEqual(tol.x3(2),2);  % fold change up: 5 * 2 = 10    
end
