function test_suite = test_util
    initTestSuite;
end

function test_var2dec_1
    dec = 12345;
    bin = [1 1 0 0 0 0 0 0 1 1 1 0 0 1];
    sig = repmat(2,1,length(bin));
    assertEqual(dec,dspace.util.var2dec(sig,bin));
end

function test_var2dec_2
    dec = 12345;
    hex = [3 0 3 9];
    sig = repmat(16,1,length(hex));
    assertEqual(dec,dspace.util.var2dec(sig,hex));
end

function test_var2dec_3
    v0 = [0 0 0;0 0 1;0 0 2;1 0 0;1 0 1;1 0 2];
    d = dspace.util.var2dec([2;1;3],v0);
    assertEqual(d,(0:5)');
end

function test_dec2var_1
    dec = 12345;
    bin = [1 1 0 0 0 0 0 0 1 1 1 0 0 1];
    sig = repmat(2,1,length(bin));
    assertEqual(bin,dspace.util.dec2var(sig,dec));
end

function test_dec2var_2
    dec = 12345;
    hex = [3 0 3 9];
    sig = repmat(16,1,length(hex));
    assertEqual(hex,dspace.util.dec2var(sig,dec));
end

function test_dec2var_3
    v = dspace.util.dec2var([2;1;3],(0:5)');
    v0 = [0 0 0;0 0 1;0 0 2;1 0 0;1 0 1;1 0 2];
    assertEqual(v,v0);
end

function test_sym2str
    a = {'alpha1','beta2','x3','g4'};
    b = sym(a);
    c = dspace.util.sym2str(b);
    assertEqual(class(b),'sym');
    assertEqual(a,c);
end

function test_vector_combinations
    a = (1:2);
    b = (1:3);
    c = (1:4);
    [aa,bb,cc] = ndgrid(a,b,c);
    xx0 = [aa(:),bb(:),cc(:)]';
    xx = dspace.util.vector_combinations(a,b,c);
    assertEqual(xx,xx0);
end

function test_safe_subs
    a = dspace.util.safe_subs(cat(3,sym('a'),sym('b')),{'a','b'},{1,1});
    a = double(a);
    assertEqual(a,cat(3,1,1));
end

function test_safe_permute
    sz = size(dspace.util.safe_permute(sym(zeros(1,2)),[2,1]));
    assertEqual(sz,[2,1]);
end

function test_index_1
    A = [2;3;4];
    a = dspace.util.index(A,2);
    assertEqual(a,A(2));
end

function test_index_2
    A = [2,3;4,5];
    a = dspace.util.index(A,2,2);
    assertEqual(a,A(2,2));
end

function test_index_3
    A = cat(3,[2,3;4,5],[6,7;8,9]);
    a = dspace.util.index(A,2,2,2);
    assertEqual(a,A(2,2,2));
end

function test_getfields
    s = struct();
    s.b = 1;
    s.c = false;
    s.a = 'test';

    vals = dspace.util.getfields(s,{'a','b'});
    assertEqual(vals,{'test';1});
end

function test_ternary_1
    a = dspace.util.ternary('true','2','3');
    b = dspace.util.ternary('false','2','3');
    assertEqual(a,2);
    assertEqual(b,3);
end

function test_ternary_2
    f = @(x)dspace.util.ternary('~isempty(x)','x(1)','NaN');
    assertEqual(f([]),NaN);
    assertEqual(f([1]),1);
    assertEqual(f([2,1]),2);
end
